/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements org.bukkit.scoreboard.Objective {
    private final Objective objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, Objective objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    Objective getHandle() {
        return this.objective;
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.objective.m_83320_();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.objective.m_83322_());
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.objective.m_83316_(CraftChatMessage.fromString(displayName)[0]);
    }

    @Override
    public String getCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria.bukkitName;
    }

    @Override
    public boolean isModifiable() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return !this.criteria.criteria.m_83621_();
    }

    @Override
    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        Objective objective = this.objective;
        for (int i = 0; i < 3; ++i) {
            if (board.m_83416_(i) != objective) continue;
            board.m_7136_(i, null);
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.m_7136_(slotNumber, this.getHandle());
        }
    }

    @Override
    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        Objective objective = this.objective;
        for (int i = 0; i < 3; ++i) {
            if (board.m_83416_(i) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i);
        }
        return null;
    }

    @Override
    public void setRenderType(RenderType renderType) throws IllegalStateException {
        Validate.notNull((Object)((Object)renderType), (String)"RenderType cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.objective.m_83314_(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    @Override
    public RenderType getRenderType() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.m_83324_());
    }

    @Override
    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, player.getName());
    }

    @Override
    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        Validate.isTrue((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Score '" + entry + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.m_83502_(this.objective);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.m_83477_(this.objective.m_83320_()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

